#ifndef __ELIZA__H__
#define __ELIZA__H__

#pragma warning(disable:4786)

#include "recorder.h"
#include "strings.h"
#include <windows.h>
#include <direct.h>
#include <sstream>
#include <algorithm>
#include <fstream>
#include <list>
#include <stack>
#include <ctime>


template<typename T>
void shuffle(T &array, size_t size) {
	for(int i = 0; i < size; ++i) {
		int index = rand() % size;
		std::swap(array[i], array[index]);
	}
}

typedef std::vector<std::string> vstring;




class Eliza {
	
	struct data {
		vstring keywords;
		vstring contexts;
		vstring responses;
		vstring cmd;
	};

	struct transpos {
		std::string verbP1;
		std::string verbP2;
	};

	Tokenizer tok;

public:
	Eliza ()
		: m_bQuitProgram(0), linePos(2), m_bNewData(0), m_bLearning(0)
	{
		srand((unsigned int) time(NULL));
		read_time_delay(time_delay);
	}

	~Eliza () 
	{};

	void load_data();
	void save_data();

	void make_correction();
	void respond();

	void preProcessInput();
	void get_input();

	void start();
	
	void print_response();
	void print_database_content();
	void save_unknown_sentences();

	bool quit() const {  
		return m_bQuitProgram; 
	}

	bool learn() const {
		return m_bNewData;
	}

private:
	void saveTopic(const vstring vList, const std::string sSymbol);
	void saveComment(const string comment);
	void saveTransposTable();
	void saveKeyWords();

	bool transpose( std::string &str ) const;

	void transpose_sentence( std::string &str );

	void handleRepetition( vstring &vList );
	void handle_repetition();

	bool bot_repeat() const;

	void verify_context(vstring vContext);

	void print_current_data();

	void find_keyword();

	void execute();
	
	void dump_data();
	void selectResponse( vstring v );
	void extract_suffix();

	void clear();

	bool isGoodKey(const std::string key, const std::string bkey, int pos, int bestp) const;
private:
	std::string					m_sInput;
	std::string					m_sResponse;
	std::string					m_sPrevInput;
	std::string					m_sKeyWord;
	std::string					m_sSuffix;
	std::string					m_sPrevResponse;
	std::string					m_sCommand;
	vstring						comments;
	vstring						signOn;
	vstring						nullResponse;
	vstring						myResponse;
	vstring						noKeyWord;
	vstring						topicChanger;
	vstring						subjectRecall;
	vstring						unknownSentences;
	vstring						inputRepeat;
	vstring						keyword_list;
	vstring						response_list;
	vstring						previous_inputs;
	vstring						command_list;
	vstring						vResponseLog;
	bool						m_bGoodContext;
	bool						m_bQuitProgram;
	bool						m_bLearning;
	bool						m_bNewData;
	unsigned int				m_nTransPosNum;
	unsigned int				linePos;
	data						current_data;
	std::fstream				scriptfile;
	std::stack<std::string>		previous_responses;
	std::list<std::string>		extendedResponseList;
	std::vector<transpos>		transpos_list;
	std::stack<std::string>		memory;
	std::vector<data>			database;
	std::vector<double>			time_delay;

};


#endif